//---------------------------------------------------------------------------------------
//  FILE:    Utilities_LW
//  AUTHOR:  tracktwo (Pavonis Interactive)
//
//  PURPOSE: Miscellaneous helper routines.
//--------------------------------------------------------------------------------------- 

class RM_Helpers extends Object config(GameData_SoldierSkills);

var config float RadiiBonus;

// Attempt to find a tile near the given tile to spawn a unit. Will attempt one within "FirstRange"
// radius first, and then "SecondRange" if it fails to locate one. Returns false if we can't find a tile.
function static bool GetChargeTileNearTile(out TTile Tile, int FirstRange, int SecondRange)
{
    local XComWorldData WorldData;
    local array<TTile> TilePossibilities;

    WorldData = `XWORLD;
    // Try to find a valid tile near the randomly chosen tile, and spawn there.
    WorldData.GetSpawnTilePossibilities(Tile, FirstRange, FirstRange, 3, TilePossibilities);
    class'RM_Helpers'.static.RemoveInvalidTiles(TilePossibilities);

    if (TilePossibilities.Length == 0) 
    {
        // Try again, widening the search quite a bit
        WorldData.GetSpawnTilePossibilities(Tile, SecondRange, SecondRange, 3, TilePossibilities);
        class'RM_Helpers'.static.RemoveInvalidTiles(TilePossibilities);
    }

    if (TilePossibilities.Length != 0)
    {
        Tile = TilePossibilities[`SYNC_RAND_STATIC(TilePossibilities.Length)];
        return true;
    }

    // Still no good!
	`log("Shit, Charge could not find a valid tile.");
    return false;
}


function static RemoveInvalidTiles(out array<TTile> Tiles)
{
    local XComWorldData WorldData;
    local TTile Tile;
    local int i;

    WorldData = `XWORLD;
    i = 0;
    while (i < Tiles.Length)
    {
        Tile = Tiles[i];
        if (WorldData.IsTileOutOfRange(Tile) || !WorldData.CanUnitsEnterTile(Tile)) // we can't use a tile outside of the gameplay area, nor an area already occupied by a unit
        {
            Tiles.Remove(i, 1);
        }
        else
        {
            ++i;
        }
    }
}